<?php
namespace YayMail\Elements;

use YayMail\Abstracts\BaseElement;
use YayMail\Utils\SingletonTrait;

/**
 * Column Elements
 */
class ColumnLayout extends BaseElement {

    use SingletonTrait;

    protected static $type = 'column_layout';

    public $available_email_ids = [ YAYMAIL_ALL_EMAILS ];

    public static function get_data( $amount = 1, $attributes = [] ) {
        return [
            'id'        => uniqid(),
            'type'      => self::$type,
            'name'      => self::get_name( $amount ),
            'icon'      => self::get_icon( $amount ),
            'group'     => 'general',
            'available' => true,
            'position'  => 150,
            'children'  => isset( $attributes['children'] ) ? $attributes['children'] : self::get_nested_columns( $amount ),
            'data'      => [
                'amount_of_columns'      => [
                    'value_path'    => 'amount_of_columns',
                    'default_value' => $amount,
                ],
                'column_width'           => [
                    'value_path' => 'column_width',
                    'component'  => 'ColumnWidth',
                    'title'      => __( 'Column width (%)', 'yaymail' ),
                ],
                'padding'                => [
                    'value_path'    => 'padding',
                    'component'     => 'Spacing',
                    'title'         => __( 'Padding', 'yaymail' ),
                    'default_value' => isset( $attributes['padding'] ) ? $attributes['padding'] : [
                        'top'    => '15',
                        'right'  => '0',
                        'bottom' => '15',
                        'left'   => '0',
                    ],
                ],
                'background_color'       => [
                    'value_path'    => 'background_color',
                    'component'     => 'Color',
                    'title'         => __( 'Background color', 'yaymail' ),
                    'default_value' => isset( $attributes['background_color'] ) ? $attributes['background_color'] : '#fff',
                ],
                'background_image'       => [
                    'value_path'    => 'background_image',
                    'component'     => 'BackgroundImage',
                    'title'         => __( 'Background image', 'yaymail' ),
                    'default_value' => isset( $attributes['background_image'] ) ? $attributes['background_image'] : [
                        'url'        => '',
                        'position'   => 'default',
                        'x_position' => 0,
                        'y_position' => 0,
                        'repeat'     => 'default',
                        'size'       => 'default',
                    ],
                ],
                'inner_border_radius'    => [
                    'value_path'    => 'inner_border_radius',
                    'component'     => 'Spacing',
                    'title'         => __( 'Inner border radius', 'yaymail' ),
                    'default_value' => [
                        'top_left'     => isset( $attributes['inner_border_radius']['top_left'] ) ? $attributes['inner_border_radius']['top_left'] : '0',
                        'top_right'    => isset( $attributes['inner_border_radius']['top_right'] ) ? $attributes['inner_border_radius']['top_right'] : '0',
                        'bottom_left'  => isset( $attributes['inner_border_radius']['bottom_left'] ) ? $attributes['inner_border_radius']['bottom_left'] : '0',
                        'bottom_right' => isset( $attributes['inner_border_radius']['bottom_right'] ) ? $attributes['inner_border_radius']['bottom_right'] : '0',
                    ],
                    'extras_data'   => [
                        'is_border_radius' => true,
                        'class_name'       => 'yaymail-border-radius',
                    ],
                ],
                'inner_background_color' => [
                    'value_path'    => 'inner_background_color',
                    'component'     => 'Color',
                    'title'         => __( 'Inner background color', 'yaymail' ),
                    'default_value' => isset( $attributes['inner_background_color'] ) ? $attributes['inner_background_color'] : '#fff',
                ],
            ],
        ];
    }

    private static function get_nested_columns( $amount ) {
        if ( ! isset( $amount ) || $amount <= 0 ) {
            return [];
        }
        $width = 100 / $amount;

        $nested_columms = [];
        for ( $i = 0; $i < $amount; $i++ ) {
            array_push(
                $nested_columms,
                Column::get_data( $width )
            );
        }

        return $nested_columms;
    }

    private static function get_name( $amount ) {
        $column_names = [
            1 => __( 'One Column', 'yaymail' ),
            2 => __( 'Two Columns', 'yaymail' ),
            3 => __( 'Three Columns', 'yaymail' ),
            4 => __( 'Four Columns', 'yaymail' ),
        ];

        return isset( $column_names[ $amount ] ) ? $column_names[ $amount ] : 'Column';
    }

    private static function get_icon( $amount ) {
        $icons = [
            1 => '<svg xmlns="http://www.w3.org/2000/svg" id="Layer_1" data-name="Layer 1" viewBox="0 0 20 20">
  <path d="M18.75,1.25v17.5H1.25V1.25h17.5M19,1H1v18h18V1h0Z"/>
  <rect x="8.4" y="1.94" width="3.2" height="16.12"/>
</svg>',
            2 => '<svg xmlns="http://www.w3.org/2000/svg" id="Layer_1" data-name="Layer 1" viewBox="0 0 20 20">
  <path d="M18.75,1.25v17.5H1.25V1.25h17.5M19,1H1v18h18V1h0Z"/>
  <rect x="2.12" y="1.94" width="7.2" height="16.12"/>
  <rect x="10.66" y="1.94" width="7.2" height="16.12"/>
</svg>',
            3 => '<svg xmlns="http://www.w3.org/2000/svg" id="Layer_1" data-name="Layer 1" viewBox="0 0 20 20">
  <path d="M18.75,1.25v17.5H1.25V1.25h17.5M19,1H1v18h18V1h0Z"/>
  <rect x="2.07" y="1.94" width="4.36" height="16.12"/>
  <rect x="7.79" y="1.94" width="4.36" height="16.12"/>
  <rect x="13.51" y="1.94" width="4.36" height="16.12"/>
</svg>',
            4 => '<svg xmlns="http://www.w3.org/2000/svg" id="Layer_1" data-name="Layer 1" viewBox="0 0 20 20">
  <path d="M18.75,1.25v17.5H1.25V1.25h17.5M19,1H1v18h18V1h0Z"/>
  <rect x="2.07" y="1.94" width="3.2" height="16.12"/>
  <rect x="6.26" y="1.94" width="3.2" height="16.12"/>
  <rect x="10.46" y="1.94" width="3.2" height="16.12"/>
  <rect x="14.66" y="1.94" width="3.2" height="16.12"/>
</svg>',
        ];

        return isset( $icons[ $amount ] ) ? $icons[ $amount ] : $icons[1];
    }
}
